
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Pill A
    x2 = model.addVar(name="x2", lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Pill B

    # Define the objective function
    model.setObjective(3*x1 + 5*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2*x1 + 5*x2 >= 30, name="muscle_relaxant")
    model.addConstr(3*x1 + x2 >= 15, name="anxiety_medication")
    model.addConstr(4*x1 + 3*x2 >= 20, name="pain_reliever")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Pill A: {x1.varValue}")
        print(f"Pill B: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
