
import gurobipy as gp

# Create a new model
m = gp.Model("glass_company")

# Create variables
sliding_doors = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="sliding_doors")
windows = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="windows")


# Set objective function
m.setObjective(30 * sliding_doors + 25 * windows, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(sliding_doors >= 120, "min_sliding_doors")
m.addConstr(windows >= 110, "min_windows")
m.addConstr(sliding_doors <= 210, "max_sliding_doors")
m.addConstr(windows <= 170, "max_windows")
m.addConstr(sliding_doors + windows >= 250, "min_total")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of sliding doors: {sliding_doors.x}")
    print(f"Number of windows: {windows.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

