
from gurobipy import *

# Create a new model
m = Model("Glass_Company_Optimization")

# Define variables
x1 = m.addVar(name="sliding_doors", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="windows", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(30*x1 + 25*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 120, name="min_sliding_doors")
m.addConstr(x2 >= 110, name="min_windows")
m.addConstr(x1 <= 210, name="max_sliding_doors")
m.addConstr(x2 <= 170, name="max_windows")
m.addConstr(x1 + x2 >= 250, name="total_products")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sliding doors: {x1.x}")
    print(f"Windows: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
