
import gurobipy as gp

# Create a new model
model = gp.Model("Glass Company Production")

# Define variables
x1 = model.addVar(lb=0, name="sliding_doors")  # At least 0
x2 = model.addVar(lb=0, name="windows")      # At least 0

# Set objective function
model.setObjective(30*x1 + 25*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 >= 120, name="min_sliding_doors")
model.addConstr(x2 >= 110, name="min_windows")
model.addConstr(x1 <= 210, name="max_sliding_doors")
model.addConstr(x2 <= 170, name="max_windows")
model.addConstr(x1 + x2 >= 250, name="min_total_products")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Sliding doors: {x1.varValue}")
    print(f"Windows: {x2.varValue}")
    print(f"Profit: {30*x1.varValue + 25*x2.varValue}")
else:
    print("No optimal solution found.")
