
import gurobipy as gp

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
spinach = m.addVar(lb=0, name="spinach")  # Acres of spinach
kale = m.addVar(lb=0, name="kale")  # Acres of kale


# Set objective function: Maximize profit
m.setObjective(20 * spinach + 30 * kale, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(spinach + kale <= 300, "land_constraint")  # Land constraint
m.addConstr(40 * spinach + 50 * kale <= 14000, "budget_constraint")  # Budget constraint
m.addConstr(spinach + 2 * kale <= 450, "maintenance_constraint")  # Maintenance constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Acres of spinach: {spinach.x:.2f}")
    print(f"Acres of kale: {kale.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

