
from gurobipy import *

# Create a new model
m = Model("Linda_Farming_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="acres_of_spinach")
x2 = m.addVar(lb=0, name="acres_of_kale")

# Set the objective function
m.setObjective(20*x1 + 30*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(40*x1 + 50*x2 <= 14000, "budget_constraint")
m.addConstr(x1 + 2*x2 <= 450, "maintenance_time_constraint")
m.addConstr(x1 + x2 <= 300, "land_availability_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Acres of spinach: {x1.x}")
    print(f"Acres of kale: {x2.x}")
    print(f"Maximum profit: ${20*x1.x + 30*x2.x:.2f}")
else:
    print("No optimal solution found.")
