
import gurobipy as gp

# Create a new model
model = gp.Model("Linda's Farm")

# Define the variables
x1 = model.addVar(name="spinach_acres", lb=0)
x2 = model.addVar(name="kale_acres", lb=0)

# Objective function: Maximize profit
model.setObjective(20*x1 + 30*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 300, name="land_constraint")
model.addConstr(40*x1 + 50*x2 <= 14000, name="budget_constraint")
model.addConstr(x1 + 2*x2 <= 450, name="maintenance_constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal acres of spinach: {x1.varValue}")
    print(f"Optimal acres of kale: {x2.varValue}")
    print(f"Maximal profit: {model.objVal}")
else:
    print("The model is infeasible.")
