
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Amusement Park Ticketing")

# Create variables
regular_tickets = model.addVar(vtype=GRB.INTEGER, name="regular_tickets")
premium_tickets = model.addVar(vtype=GRB.INTEGER, name="premium_tickets")

# Set objective function
model.setObjective(50 * regular_tickets + 100 * premium_tickets, GRB.MAXIMIZE)

# Add constraints
model.addConstr(regular_tickets + premium_tickets <= 1000, "Total tickets")
model.addConstr(premium_tickets >= 100, "Minimum premium tickets")
model.addConstr(regular_tickets >= 5 * premium_tickets, "Regular vs premium preference")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal Solution:")
    print(f"Regular Tickets: {regular_tickets.x}")
    print(f"Premium Tickets: {premium_tickets.x}")
    print(f"Maximum Profit: ${model.objVal}")

