
from gurobipy import *

# Create a model
m = Model("Amusement_Park_Ticket_Sales")

# Define variables
x1 = m.addVar(name='regular_tickets', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='premium_tickets', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(50*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 1000, name='total_tickets')
m.addConstr(x2 >= 100, name='minimum_premium_tickets')
m.addConstr(x1 >= 5*x2, name='regular_vs_premium_ratio')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Regular Tickets = {x1.x}, Premium Tickets = {x2.x}")
    print(f"Maximum Profit: ${50*x1.x + 100*x2.x:.2f}")
else:
    print("No optimal solution found")
