
import gurobi

def solve_amusement_park_ticket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="regular_tickets", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of regular tickets
    x2 = model.addVar(name="premium_tickets", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of premium tickets

    # Objective function: Maximize 50*x1 + 100*x2
    model.setObjective(50*x1 + 100*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 1000, name="total_tickets")  # At most 1000 tickets
    model.addConstr(x2 >= 100, name="min_premium_tickets")  # At least 100 premium tickets
    model.addConstr(x1 >= 5*x2, name="regular_to_premium_ratio")  # At least 5 times as many regular tickets as premium tickets

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found: regular tickets = {x1.varValue}, premium tickets = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_amusement_park_ticket_problem()
