
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("Necklace_Production")

    # Create variables
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="diamond_necklaces") # Number of diamond necklaces
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="gold_necklaces") # Number of gold necklaces


    # Set objective function
    m.setObjective(1500*x1 + 500*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3*x1 + 5*x2 <= 30, "designing_constraint")
    m.addConstr(10*x1 + 2*x2 <= 45, "crafting_constraint")
    m.addConstr(x1 >= 0, "non_negativity_diamond")
    m.addConstr(x2 >= 0, "non_negativity_gold")


    # Optimize model
    m.optimize()

    # Print results
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
