
from gurobipy import *

# Create a model
m = Model("Jewelry_Shop_Profit")

# Define variables
x1 = m.addVar(name="diamond_necklaces", lb=0)
x2 = m.addVar(name="gold_necklaces", lb=0)

# Set the objective function
m.setObjective(1500*x1 + 500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 30, name="design_time_constraint")
m.addConstr(10*x1 + 2*x2 <= 45, name="craft_time_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal number of diamond necklaces: {x1.x}")
    print(f"Optimal number of gold necklaces: {x2.x}")
    print(f"Maximum profit: ${1500*x1.x + 500*x2.x:.2f}")
else:
    print("No optimal solution found")
