
import gurobi

def solve_necklace_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="diamond_necklaces", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="gold_necklaces", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(1500 * x1 + 500 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + 5 * x2 <= 30, name="designing_team_constraint")
    model.addConstr(10 * x1 + 2 * x2 <= 45, name="crafting_team_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of diamond necklaces: {x1.varValue}")
        print(f"Number of gold necklaces: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_necklace_problem()
