
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("eric_combo_optimization")

    # Create variables
    x1 = m.addVar(vtype=GRB.INTEGER, name="Combo_X") # Number of Combo X
    x2 = m.addVar(vtype=GRB.INTEGER, name="Combo_Y") # Number of Combo Y


    # Set objective function
    m.setObjective(12*x1 + 15*x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2*x1 + x2 <= 25, "Wireless_Keyboards")
    m.addConstr(3*x2 <= 13, "Wired_Earbuds")
    m.addConstr(2*x1 + x2 <= 19, "USB_Hubs")

    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal profit: ${m.objVal}")
        print(f"Number of Combo X: {x1.x}")
        print(f"Number of Combo Y: {x2.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
