
from gurobipy import *

# Create a new model
m = Model("Eric's Profit Maximization")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="Combo_X")
x2 = m.addVar(vtype=GRB.INTEGER, name="Combo_Y")

# Set the objective function
m.setObjective(12*x1 + 15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + x2 <= 25, "Wireless_Keyboards")
m.addConstr(3*x2 <= 13, "Wired_Earbuds")
m.addConstr(2*x1 + x2 <= 19, "USB_Hubs")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of Combo X: {x1.x}")
    print(f"Number of Combo Y: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found.")

