
import gurobipy as gp

# Create a new model
model = gp.Model("Eric's Combos")

# Define the variables
x1 = model.addVar(name="Combo_X", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="Combo_Y", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(12*x1 + 15*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*x1 + x2 <= 25, name="Wireless_Keyboard_Constraint")
model.addConstr(3*x2 <= 13, name="Wired_Earbuds_Constraint")
model.addConstr(2*x1 + x2 <= 19, name="USB_Hubs_Constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")
