
import gurobipy as gp

# Create a new model
m = gp.Model("Bob's Coffee Shop")

# Create variables
coffee = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="coffee") # Number of cups of coffee
tea = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="tea") # Number of cups of tea


# Set objective function: Maximize profit
m.setObjective(1 * coffee + 2 * tea, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * coffee + 3 * tea <= 500, "Time Constraint") # Time constraint
m.addConstr(coffee + tea <= 300, "Total Cups Constraint") # Total cups constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of cups of coffee: {coffee.x}")
    print(f"Number of cups of tea: {tea.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

