
from gurobipy import *

# Create a model
m = Model("coffee_shop")

# Define variables
x1 = m.addVar(name="cups_of_coffee", lb=0)
x2 = m.addVar(name="cups_of_tea", lb=0)

# Set the objective function
m.setObjective(1*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 3*x2 <= 500, name="time_constraint")
m.addConstr(x1 + x2 <= 300, name="product_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cups of coffee: {x1.x}")
    print(f"Cups of tea: {x2.x}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found")
