
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="coffee", lb=0)
x2 = model.addVar(name="tea", lb=0)

# Set the objective function
model.setObjective(x1 + 2*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + x2 <= 300, name="total_cups")
model.addConstr(5*x1 + 3*x2 <= 500, name="time_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Cups of coffee: {x1.varValue}")
    print(f"Cups of tea: {x2.varValue}")
    print(f"Max profit: {model.objVal}")
else:
    print("No optimal solution found")
