
import gurobipy as gp

# Create a new model
m = gp.Model("pet_food")

# Create variables
x1 = m.addVar(lb=0, name="bags_of_A") # Bags of A
x2 = m.addVar(lb=0, name="bags_of_B") # Bags of B

# Set objective function
m.setObjective(3.5 * x1 + 2.5 * x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * x1 + 4 * x2 >= 30, "protein_req")
m.addConstr(4 * x1 + 2 * x2 >= 35, "calcium_req")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Bags of A: {x1.x:.2f}")
    print(f"Bags of B: {x2.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

