
from gurobipy import *

# Create a new model
m = Model("Pet_Store_Mixture")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="bags_of_A", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="bags_of_B", lb=0)

# Set the objective function
m.setObjective(3.5*x1 + 2.5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 4*x2 >= 30, "protein_constraint")
m.addConstr(4*x1 + 2*x2 >= 35, "calcium_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bags of Bag A: {x1.x}")
    print(f"Number of bags of Bag B: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
