
import gurobi

def solve_pet_store_mixture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='Bag_A', lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name='Bag_B', lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize 3.50*x1 + 2.50*x2
    model.setObjective(3.50 * x1 + 2.50 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3 * x1 + 4 * x2 >= 30, name='protein_requirement')
    model.addConstr(4 * x1 + 2 * x2 >= 35, name='calcium_requirement')

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Number of bags of type A: {x1.varValue}")
        print(f"Number of bags of type B: {x2.varValue}")
        print(f"Total cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_pet_store_mixture_problem()
