
import gurobipy as gp

# Create a new model
m = gp.Model("office_design")

# Create variables
regular_desks = m.addVar(vtype=gp.GRB.INTEGER, name="regular_desks")
standing_desks = m.addVar(vtype=gp.GRB.INTEGER, name="standing_desks")

# Set objective function
m.setObjective(4 * regular_desks + 6 * standing_desks, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(150 * regular_desks + 200 * standing_desks <= 2500, "budget_constraint")
m.addConstr(6 * regular_desks + 5 * standing_desks <= 250, "space_constraint")
m.addConstr(regular_desks >= 0, "regular_desks_nonnegative")
m.addConstr(standing_desks >= 0, "standing_desks_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal seating capacity: {m.objVal}")
    print(f"Number of regular desks: {regular_desks.x}")
    print(f"Number of standing desks: {standing_desks.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

