
import gurobi

def solve_office_space_design():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="regular_desks", vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="standing_desks", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function: Maximize 4*x1 + 6*x2
    model.setObjective(4*x1 + 6*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(150*x1 + 200*x2 <= 2500, name="budget_constraint")
    model.addConstr(6*x1 + 5*x2 <= 250, name="space_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of regular desks: {x1.varValue}")
        print(f"Number of standing desks: {x2.varValue}")
        print(f"Maximum seating availability: {4*x1.varValue + 6*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_office_space_design()
