
import gurobipy as gp

# Create a new model
model = gp.Model("FishFoodProduction")

# Create variables
small_containers = model.addVar(vtype=gp.GRB.INTEGER, name="small_containers")
bulk_containers = model.addVar(vtype=gp.GRB.INTEGER, name="bulk_containers")

# Set objective function
model.setObjective(2 * small_containers + 7 * bulk_containers, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10 * small_containers + 30 * bulk_containers <= 200, "fish_food_constraint")
model.addConstr(2 * small_containers + 7 * bulk_containers <= 120, "filling_time_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Number of small containers: {small_containers.x}")
    print(f"Number of bulk containers: {bulk_containers.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

