
from gurobipy import *

# Create a new model
m = Model("Fish_Food_Production")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="small_containers")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="bulk_size_containers")

# Set the objective function
m.setObjective(2*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 30*x2 <= 200, "fish_food_availability")
m.addConstr(2*x1 + 7*x2 <= 120, "filling_time_availability")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {int(x1.x)}, {x2.varName} = {int(x2.x)}")
    print(f"Maximum Profit: ${int(m.objVal)}")
else:
    print("No optimal solution found.")
