
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="small_containers")
x2 = model.addVar(lb=0, name="bulk_size_containers")

# Define the objective function
model.setObjective(2*x1 + 7*x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(10*x1 + 30*x2 <= 200, name="fish_food_availability")
model.addConstr(2*x1 + 7*x2 <= 120, name="filling_time_availability")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of small containers: {x1.varValue}")
    print(f"Number of bulk size containers: {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found.")
