
import gurobipy as gp

# Create a new model
m = gp.Model("fitness_optimization")

# Create variables
treadmills = m.addVar(vtype=gp.GRB.CONTINUOUS, name="treadmills")
bikes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="bikes")


# Set objective function
m.setObjective(300 * treadmills + 120 * bikes, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * treadmills + 15 * bikes <= 10000, "mover_time")
m.addConstr(50 * treadmills + 30 * bikes <= 15000, "setup_time")
m.addConstr(treadmills >= 0)
m.addConstr(bikes >=0)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Treadmills: {treadmills.x}")
    print(f"Number of Stationary Bikes: {bikes.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

