
from gurobipy import *

# Create a new model
model = Model("Fitness_Company_Profit_Optimization")

# Add variables to the model
x1 = model.addVar(vtype=GRB.INTEGER, name="treadmills")
x2 = model.addVar(vtype=GRB.INTEGER, name="stationary_bikes")

# Set the objective function
model.setObjective(300*x1 + 120*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(30*x1 + 15*x2 <= 10000, "mover_time_constraint")
model.addConstr(50*x1 + 30*x2 <= 15000, "setup_time_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Treadmills: {x1.x}")
    print(f"Stationary Bikes: {x2.x}")
    print(f"Maximum Profit: ${300*x1.x + 120*x2.x}")
else:
    print("No optimal solution found.")
