
import gurobipy as gp

# Create a new model
model = gp.Model("Fitness_Company_Optimization")

# Define variables
x1 = model.addVar(name="treadmills", lb=0, vtype=gp.GRB.INTEGER)  # Number of treadmills
x2 = model.addVar(name="stationary_bikes", lb=0, vtype=gp.GRB.INTEGER)  # Number of stationary bikes

# Objective function: Maximize profit
model.setObjective(300*x1 + 120*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(30*x1 + 15*x2 <= 10000, name="mover_time_constraint")  # Mover time constraint
model.addConstr(50*x1 + 30*x2 <= 15000, name="setup_time_constraint")  # Setup time constraint

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
