
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("toy_production")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="RC_drones") # Number of RC drones
x2 = m.addVar(vtype=GRB.INTEGER, name="model_cars") # Number of model cars


# Set objective function
m.setObjective(50*x1 + 90*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 4*x2 <= 200, "wood_constraint")
m.addConstr(30*x1 + 20*x2 <= 900, "paint_constraint")
m.addConstr(x1 >= 0, "non_negativity_x1")  # Ensure non-negative production
m.addConstr(x2 >= 0, "non_negativity_x2")  # Ensure non-negative production


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of RC drones to produce: {x1.x}")
    print(f"Number of model cars to produce: {x2.x}")

