
from gurobipy import *

# Create a new model
m = Model("Toy_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="RC_Drones", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Model_Cars", lb=0)

# Set the objective function
m.setObjective(50*x1 + 90*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 4*x2 <= 200, "Wood_Constraint")
m.addConstr(30*x1 + 20*x2 <= 900, "Paint_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"RC Drones: {x1.x}")
    print(f"Model Cars: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
