
import gurobipy as gp

# Create a new model
model = gp.Model("Toy Production")

# Define the variables
x1 = model.addVar(name="RC_drones", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="model_cars", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(50*x1 + 90*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(7*x1 + 4*x2 <= 200, name="wood_constraint")
model.addConstr(30*x1 + 20*x2 <= 900, name="paint_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum profit: ${50*x1.varValue + 90*x2.varValue:.2f}")
else:
    print("The model is infeasible.")
