
from gurobipy import *

# Create a model
m = Model("Pie_Shop_Profit")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="apple_pies")
x2 = m.addVar(vtype=GRB.INTEGER, name="peach_pies")

# Set objective function
m.setObjective(7*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 15, "min_apple_pies")
m.addConstr(x2 >= 12, "min_peach_pies")
m.addConstr(x1 <= 20, "max_apple_pies")
m.addConstr(x2 <= 18, "max_peach_pies")
m.addConstr(x1 + x2 <= 30, "total_pies_limit")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of apple pies: {x1.x}")
    print(f"Number of peach pies: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
