
import gurobipy as gp

# Create a new model
model = gp.Model("PieShop")

# Define variables
x1 = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="apple_pies")
x2 = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="peach_pies")

# Set bounds according to the problem
x1.lb = 15
x2.lb = 12
x1.ub = 20
x2.ub = 18

# Objective function
model.setObjective(7*x1 + 8*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 20, name="apple_pies_max")
model.addConstr(x2 <= 18, name="peach_pies_max")
model.addConstr(x1 + x2 <= 30, name="total_pies_max")

# Add constraints that are already considered in bounds
# model.addConstr(x1 >= 15, name="apple_pies_min")
# model.addConstr(x2 >= 12, name="peach_pies_min")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Apple pies: {x1.varValue}")
    print(f"Peach pies: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found")
