
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("minimize_wages")

# Create variables
engineers = m.addVar(lb=0, vtype=GRB.INTEGER, name="engineers")
interns = m.addVar(lb=0, vtype=GRB.INTEGER, name="interns")

# Set objective function
m.setObjective(3000 * engineers + 750 * interns, GRB.MINIMIZE)

# Add constraints
m.addConstr(engineers + interns >= 100, "total_workers")
m.addConstr(interns >= 20, "min_interns")
m.addConstr(interns >= (1/3) * engineers, "intern_engineer_ratio")
m.addConstr(3000 * engineers + 750 * interns <= 200000, "max_payroll")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of engineers: {engineers.x}")
    print(f"Number of interns: {interns.x}")
    print(f"Total weekly wages: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

