
from gurobipy import *

# Create a model
m = Model("Engineering_Firm_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="number_of_engineers")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="number_of_interns")

# Set the objective function
m.setObjective(3000*x1 + 750*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1 + x2 >= 100, "total_workers")
m.addConstr(x2 >= 20, "min_interns")
m.addConstr(x2 >= (1/3)*x1, "intern_to_engineer_ratio")
m.addConstr(3000*x1 + 750*x2 <= 200000, "max_payroll")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Engineers: {x1.x}")
    print(f"Number of Interns: {x2.x}")
    print(f"Total Payroll: ${3000*x1.x + 750*x2.x}")
else:
    print("No optimal solution found")
