
import gurobipy as gp

def solve_optimization_problem():
    # Create a new model
    model = gp.Model("Engineering_Firm_Optimization")

    # Define the variables
    x1 = model.addVar(name="engineers", obj=3000)  # Number of engineers
    x2 = model.addVar(name="interns", obj=750)     # Number of interns

    # Define the constraints
    model.addConstr(x1 + x2 >= 100, name="total_workers")
    model.addConstr(x2 >= 20, name="min_interns")
    model.addConstr(x2 >= (1/3)*x1, name="interns_to_engineers_ratio")
    model.addConstr(3000*x1 + 750*x2 <= 200000, name="max_payroll")

    # Set the objective to minimize the total payroll
    model.setObjective(x1.obj * x1 + x2.obj * x2, gp.GRB.MINIMIZE)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Number of Engineers: {x1.varValue}")
        print(f"Number of Interns: {x2.varValue}")
        print(f"Total Payroll: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
