
import gurobipy as gp

# Create a new model
m = gp.Model("Minimize Cost")

# Create variables
pork = m.addVar(lb=0, name="pork")  # Servings of pork meat
shrimp = m.addVar(lb=0, name="shrimp")  # Servings of shrimp meat

# Set objective function: Minimize cost
m.setObjective(6.5 * pork + 9 * shrimp, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * pork + 5 * shrimp >= 25, "calcium_req")  # Calcium requirement
m.addConstr(5 * pork + 9 * shrimp >= 35, "magnesium_req") # Magnesium requirement


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Servings of Pork Meat: {pork.x:.2f}")
    print(f"Servings of Shrimp Meat: {shrimp.x:.2f}")

