
from gurobipy import *

# Create a new model
m = Model("Calcium_Magnesium_Optimization")

# Define the variables
x1 = m.addVar(lb=0, name="pork_servings")
x2 = m.addVar(lb=0, name="shrimp_servings")

# Set the objective function
m.setObjective(6.5*x1 + 9*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 >= 25, "calcium_constraint")
m.addConstr(5*x1 + 9*x2 >= 35, "magnesium_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Servings of pork meat: {x1.x}")
    print(f"Servings of shrimp meat: {x2.x}")
    print(f"Total cost: ${6.5*x1.x + 9*x2.x:.2f}")
else:
    print("No optimal solution found.")
