
import gurobipy as gp

# Create a new model
model = gp.Model("Diet Problem")

# Define the variables
x1 = model.addVar(name="pork_meat", lb=0)  # Servings of pork meat
x2 = model.addVar(name="shrimp_meat", lb=0)  # Servings of shrimp meat

# Objective function: minimize cost
model.setObjective(6.5 * x1 + 9 * x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(3 * x1 + 5 * x2 >= 25, name="calcium_intake")
model.addConstr(5 * x1 + 9 * x2 >= 35, name="magnesium_intake")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Servings of pork meat: {x1.varValue}")
    print(f"Servings of shrimp meat: {x2.varValue}")
    print(f"Total cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
