
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("ButcherShop")

    # Create variables
    burgers = m.addVar(vtype=GRB.INTEGER, name="burgers")
    sausages = m.addVar(vtype=GRB.INTEGER, name="sausages")


    # Set objective function
    m.setObjective(5 * burgers + 3 * sausages, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(20 * burgers + 10 * sausages <= 1000, "ground_meat_constraint")
    m.addConstr(sausages >= 3 * burgers, "sausage_burger_ratio")
    m.addConstr(burgers >= 10, "min_burgers")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal Solution Found:")
        print(f"Number of Burgers: {burgers.x}")
        print(f"Number of Sausages: {sausages.x}")
        print(f"Maximum Profit: ${m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
