
from gurobipy import *

# Create a new model
m = Model("Butcher_Shop_Optimization")

# Define variables
x1 = m.addVar(name='x1', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='x2', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(5*x1 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 10*x2 <= 1000, name='meat_limit')
m.addConstr(x2 >= 3*x1, name='sausage_to_burger_ratio')
m.addConstr(x1 >= 10, name='minimum_burgers')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of burgers: {x1.x}")
    print(f"Number of sausages: {x2.x}")
    print(f"Maximum profit: ${5*x1.x + 3*x2.x:.2f}")
else:
    print("No optimal solution found.")
