
import gurobi

def butcher_shop_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="burgers", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of burgers
    x2 = model.addVar(name="sausages", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of sausages

    # Objective function: Maximize profit
    model.setObjective(5 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20 * x1 + 10 * x2 <= 1000, name="meat_constraint")  # Total meat constraint
    model.addConstr(x2 >= 3 * x1, name="ratio_constraint")  # Sausages to burgers ratio constraint
    model.addConstr(x1 >= 10, name="min_burgers_constraint")  # Minimum burgers constraint

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of burgers: {x1.varValue}")
        print(f"Optimal number of sausages: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

butcher_shop_optimization()
