
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("phone_production")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # Regular phones
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # Premium phones


# Set objective function
m.setObjective(200*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 20, "regular_phone_demand")
m.addConstr(x2 <= 15, "premium_phone_demand")
m.addConstr(x1 + x2 <= 30, "total_phone_demand")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of regular phones to produce: {x1.x:.2f}")
    print(f"Number of premium phones to produce: {x2.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

