
from gurobipy import *

# Create a new model
m = Model("phone_production")

# Add variables to the model
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="regular_phones")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="premium_phones")

# Set the objective function
m.setObjective(200*x1 + 300*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 20, "regular_phone_limit")
m.addConstr(x2 <= 15, "premium_phone_limit")
m.addConstr(x1 + x2 <= 30, "total_phone_limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular phones: {x1.x}")
    print(f"Premium phones: {x2.x}")
    print(f"Total profit: ${200*x1.x + 300*x2.x:.2f}")
else:
    print("No optimal solution found")
