
import gurobipy as gp

# Create a new model
model = gp.Model("Phone_Production")

# Define variables
x1 = model.addVar(lb=0, ub=20, name="regular_phones")
x2 = model.addVar(lb=0, ub=15, name="premium_phones")

# Objective function: Maximize profit
model.setObjective(200*x1 + 300*x2, gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(x1 <= 20, name="demand_regular")
model.addConstr(x2 <= 15, name="demand_premium")
model.addConstr(x1 + x2 <= 30, name="total_demand")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Regular Phones: {x1.varValue}")
    print(f"Premium Phones: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found.")
