
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_production")

# Create variables
coffee_tables = m.addVar(vtype=GRB.CONTINUOUS, name="coffee_tables")
bedside_tables = m.addVar(vtype=GRB.CONTINUOUS, name="bedside_tables")

# Set objective function
m.setObjective(50 * coffee_tables + 90 * bedside_tables, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5 * coffee_tables + 4.5 * bedside_tables <= 6500, "parts_production")
m.addConstr(3 * coffee_tables + 2 * bedside_tables <= 3500, "assembly")
m.addConstr(1.5 * coffee_tables + 3.5 * bedside_tables <= 5000, "polishing")
m.addConstr(coffee_tables >= 0, "coffee_tables_nonnegative")  # Ensure non-negative production
m.addConstr(bedside_tables >= 0, "bedside_tables_nonnegative") # Ensure non-negative production


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of coffee tables to produce: {coffee_tables.x}")
    print(f"Number of bedside tables to produce: {bedside_tables.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

