
from gurobipy import *

# Create a new model
m = Model("Furniture_Production")

# Define variables
x1 = m.addVar(name="coffee_tables", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="bedside_tables", vtype=GRB.CONTINUOUS, lb=0)

# Set objective function
m.setObjective(50*x1 + 90*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*x1 + 4.5*x2 <= 6500, name="parts_production")
m.addConstr(3*x1 + 2*x2 <= 3500, name="assembling")
m.addConstr(1.5*x1 + 3.5*x2 <= 5000, name="polishing")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Coffee tables: {x1.x}")
    print(f"Bedside tables: {x2.x}")
    print(f"Total profit: ${50*x1.x + 90*x2.x:.2f}")
else:
    print("No optimal solution found.")
