
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="coffee_tables", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="bedside_tables", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Set the objective function
    model.setObjective(50 * x1 + 90 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2.5 * x1 + 4.5 * x2 <= 6500, name="parts_production")
    model.addConstr(3 * x1 + 2 * x2 <= 3500, name="parts_assembly")
    model.addConstr(1.5 * x1 + 3.5 * x2 <= 5000, name="tables_polishing")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Coffee tables: {x1.varValue}")
        print(f"Bedside tables: {x2.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
